<?php

    require_once("requestFunctions.php");

    $start_time_ajusted = "T00:00:00".$timezone_val;
    $end_time_ajusted = "T23:59:59".$timezone_val;
    
    function product1($data){  // buy one get one free
        global $headers;
        global $store_hash;
        global $API_PATH;
        global $start_time_ajusted;
        global $end_time_ajusted;
        global $channel_id;
        
        $promo_name = $data[0];
        $target_prod_id = $data[1];
        $target_prod_qty = $data[2];
        $promo_prod_id = $data[3];
        $promo_prod_qty = $data[4];
        $currency_code = $data[5];
        $product_page_content = $data[6];
        $cart_page_content = $data[7];
        $congratulation_content = $data[8];
        $start_date = date("Y-m-d", strtotime($data[9]));
        $end_date = date("Y-m-d", strtotime($data[10]));

        $post_data = array(
            'name'=> $promo_name,
            "channels"=>array(
                array(
                    "id"=> $channel_id
                )
            ),
            'redemption_type'=>'AUTOMATIC',
            "currency_code"=> $currency_code,
            'rules'=>array(
                array(
                    'action'=>array(
                        'cart_items'=>array(
                            'discount'=>array(
                                'percentage_amount'=>'100'
                            ),
                            'strategy'=>'LEAST_EXPENSIVE',
                            'add_free_item'=>true,
                            'as_total'=>false,
                            'include_items_considered_by_condition'=>false,
                            'items'=>array(
                                'products'=>array(
                                    $promo_prod_id
                                )
                            ),
                            'quantity'=>$promo_prod_qty
                        )
                    ),
                    'apply_once'=>false,
                    'stop'=>false,
                    'condition'=>array(
                        'cart'=>array(
                            'items'=>array(
                                'products'=>array(
                                    $target_prod_id
                                )
                            ),
                            'minimum_quantity'=>$target_prod_qty
                        )
                    )
                )
            ),
            'notifications'=>array(
                array(
                    'type'=>'UPSELL',
                    'content'=>$product_page_content,
                    'locations'=>array(
                        'HOME_PAGE','PRODUCT_PAGE','CART_PAGE'
                    )
                ),
                array(
                    'type'=>'ELIGIBLE',
                    'content'=>$cart_page_content,
                    'locations'=>array(
                        'CART_PAGE'
                    )
                ),
                array(
                    'type'=>'APPLIED',
                    'content'=>$congratulation_content,
                    'locations'=>array(
                        'CART_PAGE'
                    )
                )
            ),
            // 'priority'=>1,
            'stop'=>false,
            'start_date'=>$start_date.$start_time_ajusted,
            'end_date'=>$end_date.$end_time_ajusted,
            'status'=>'ENABLED'
        );

        $post_data = json_encode($post_data);
        $url = $API_PATH."/v3/promotions";
        $response = curlPostRequest($url, $headers, $post_data);
        // echo "<pre>";
        // print_r($response);
        // echo "</pre>";
        // exit();
        if($response["data"]){
            return array("status"=> "success", "message"=> "Promotion created successfuly!");
        }
        else{
            return array("status"=> "error", "message"=> $promo_name);
        }

    }
    
    function product2($data){  // Buy (X units) of Product A, Get (Y units) of Product B For $ or % Off Per Unit
        global $headers;
        global $store_hash;
        global $API_PATH;

        global $start_time_ajusted;
        global $end_time_ajusted;
        global $channel_id;
        
        $promo_name = $data[0];
        $target_prod_id = $data[1];
        $target_prod_qty = $data[2];
        $promo_prod_id = $data[3];
        $promo_prod_qty = $data[4];
        $percentage = $data[5];
        $currency_code = $data[6];
        $product_page_content = $data[7];
        $cart_page_content = $data[8];
        $congratulation_content = $data[9];
        $start_date = date("Y-m-d", strtotime($data[10]));
        $end_date = date("Y-m-d", strtotime($data[11]));

        $post_data = array(
            "name"=> $promo_name,
            "channels"=>array(
                array(
                    "id"=> $channel_id
                )
            ),
            "redemption_type"=> "AUTOMATIC",
            "currency_code"=> $currency_code,
            "rules"=>array(
                array(
                "action"=> array(
                    "cart_items"=> array(
                    "discount"=> array(
                        "percentage_amount"=> $percentage
                    ),
                    "strategy"=> "LEAST_EXPENSIVE",
                    "as_total"=> false,
                    "include_items_considered_by_condition"=> false,
                    "items"=> array(
                        "products"=>array(
                        $promo_prod_id
                        )
                    ),
                    "quantity"=> $promo_prod_qty
                    )
                ),
                "apply_once"=> false,
                "stop"=> false,
                "condition"=> array(
                    "cart"=> array(
                    "items"=> array(
                        "products"=>array(
                        $target_prod_id
                        )
                    ),
                    "minimum_quantity"=> $target_prod_qty
                    )
                )
                )
            ),
            "notifications"=>array(
                array(
                "type"=> "UPSELL",
                "content"=> $product_page_content,
                "locations"=>array(
                    'HOME_PAGE','PRODUCT_PAGE','CART_PAGE'
                )
                ),
                array(
                "type"=> "ELIGIBLE",
                "content"=> $cart_page_content,
                "locations"=>array(
                    "CART_PAGE"
                )
                ),
                array(
                "type"=> "APPLIED",
                "content"=> $congratulation_content,
                "locations"=>array(
                    "CART_PAGE"
                )
                )
            ),
            "stop"=> false,
            "status"=> "ENABLED",
            'start_date'=>$start_date.$start_time_ajusted,
            'end_date'=>$end_date.$end_time_ajusted,
        );

        $post_data = json_encode($post_data);
        $url = $API_PATH."/v3/promotions";
        $response = curlPostRequest($url, $headers, $post_data);
        if($response["data"]){
            return array("status"=> "success", "message"=> "Promotion created successfuly!");
        }
        else{
            return array("status"=> "error", "message"=> $promo_name);
        }

    }
    
    function product3($data){  // Get $ or % Off Product X

        global $headers;
        global $store_hash;
        global $API_PATH;


        global $start_time_ajusted;
        global $end_time_ajusted;
        global $channel_id;
        
        $promo_name = $data[0];
        $minimum_spend = $data[1];
        $promo_prod_id = $data[2];
        $promo_prod_qty = $data[3];
        $percentage = $data[4];
        $currency_code = $data[5];
        $product_page_content = $data[6];
        $cart_page_content = $data[7];
        $congratulation_content = $data[8];
        $start_date = date("Y-m-d", strtotime($data[9]));
        $end_date = date("Y-m-d", strtotime($data[10]));

        $post_data = array(
            "name"=> $promo_name,
            "channels"=>array(
                array(
                    "id"=> $channel_id
                )
            ),
            "redemption_type"=> "AUTOMATIC",
            "currency_code"=> $currency_code,
            "rules"=> array(
                array(
                  "action"=> array(
                    "cart_items"=> array(
                      "discount"=> array(
                        "percentage_amount"=> $percentage
                      ),
                      "strategy"=> "LEAST_EXPENSIVE",
                      "as_total"=> false,
                      "include_items_considered_by_condition"=> false,
                      "items"=> array(
                        "products"=> array(
                          $promo_prod_id
                        )
                      ),
                      "quantity"=> $promo_prod_qty
                    )
                  ),
                  "apply_once"=> true,
                  "stop"=> false,
                  "condition"=> array(
                    "cart"=> array(
                      "minimum_spend"=> $minimum_spend
                    )
                  )
                )
              ),
            "notifications"=>array(
                array(
                "type"=> "UPSELL",
                "content"=> $product_page_content,
                "locations"=>array(
                    'HOME_PAGE','PRODUCT_PAGE','CART_PAGE'
                )
                ),
                array(
                "type"=> "ELIGIBLE",
                "content"=> $cart_page_content,
                "locations"=>array(
                    "CART_PAGE"
                )
                ),
                array(
                "type"=> "APPLIED",
                "content"=> $congratulation_content,
                "locations"=>array(
                    "CART_PAGE"
                )
                )
            ),
            "stop"=> false,
            "status"=> "ENABLED",
            'start_date'=>$start_date.$start_time_ajusted,
            'end_date'=>$end_date.$end_time_ajusted,
        );

        $post_data = json_encode($post_data);
        $url = $API_PATH."/v3/promotions";
        $response = curlPostRequest($url, $headers, $post_data);
        if($response["data"]){
            return array("status"=> "success", "message"=> "Promotion created successfuly!");
        }
        else{
            return array("status"=> "error", "message"=> $promo_name);
        }

    }
    
    function product4($data){  // Take X% Off the Most Expensive Item in The Cart
        global $headers;
        global $store_hash;
        global $API_PATH;

        global $start_time_ajusted;
        global $end_time_ajusted;
        global $channel_id;
        

        $promo_name = $data[0];
        $percentage = $data[1];
        $currency_code = $data[2];
        $product_page_content = $data[3];
        $cart_page_content = $data[4];
        $congratulation_content = $data[5];
        $start_date = date("Y-m-d", strtotime($data[6]));
        $end_date = date("Y-m-d", strtotime($data[7]));

        $post_data = array(
            "name"=> $promo_name,
            "channels"=>array(
                array(
                    "id"=> $channel_id
                )
            ),
            "redemption_type"=> "AUTOMATIC",
            "currency_code"=> $currency_code,
            "rules"=>array(
                array(
                    "action"=> array(
                        "cart_items"=> array(
                            "discount"=> array(
                                "percentage_amount"=> $percentage
                            ),
                            "strategy"=> "MOST_EXPENSIVE",
                            "as_total"=> false,
                        )
                    ),
                    "apply_once"=> true,
                    "stop"=> false,
                )
            ),
            "notifications"=>array(
                array(
                    "type"=> "UPSELL",
                    "content"=> $product_page_content,
                    "locations"=>array(
                        'HOME_PAGE','PRODUCT_PAGE','CART_PAGE'
                    )
                ),
                array(
                    "type"=> "ELIGIBLE",
                    "content"=> $cart_page_content,
                    "locations"=>array(
                        "CART_PAGE"
                    )
                ),
                array(
                    "type"=> "APPLIED",
                    "content"=> $congratulation_content,
                    "locations"=>array(
                        "CART_PAGE"
                    )
                )
            ),
            "stop"=> false,
            "status"=> "ENABLED",
            'start_date'=>$start_date.$start_time_ajusted,
            'end_date'=>$end_date.$end_time_ajusted,
        );

        $post_data = json_encode($post_data);
        $url = $API_PATH."/v3/promotions";
        $response = curlPostRequest($url, $headers, $post_data);
        if($response["data"]){
            return array("status"=> "success", "message"=> "Promotion created successfuly!");
        }
        else{
            return array("status"=> "error", "message"=> $promo_name);
        }

    }

    function product5($data){  // Amount Off

        global $headers;
        global $store_hash;
        global $API_PATH;

        global $start_time_ajusted;
        global $end_time_ajusted;
        global $channel_id;
        

        $promo_name = $data[0];
        $promo_prod_id = $data[1];
        $fixed_amount = $data[2];
        $currency_code = $data[3];
        $product_page_content = $data[4];
        $cart_page_content = $data[5];
        $congratulation_content = $data[6];
        $start_date = date("Y-m-d", strtotime($data[7]));
        $end_date = date("Y-m-d", strtotime($data[8]));

        $post_data = array(
            "name"=> $promo_name,
            "channels"=>array(
                array(
                    "id"=> $channel_id
                )
            ),
            "redemption_type"=> "AUTOMATIC",
            "currency_code"=> $currency_code,
            "rules"=>array(
                array(
                    "action"=> array(
                        "cart_items"=> array(
                            "discount"=> array(
                                "fixed_amount"=> $fixed_amount
                            ),
                            "items"=> array(
                                "products"=> array(
                                  $promo_prod_id
                                )
                            ),
                            "quantity"=> 1,
                            "include_items_considered_by_condition"=> true
                        )
                    ),
                    "stop"=> false,
                    "apply_once"=> false,
                    "condition"=> array(
                        "cart"=> array(
                            "items"=> array(
                                "products"=> array(
                                    $promo_prod_id
                                )
                            )
                        )
                    ),
                )
            ),
            "notifications"=>array(
                array(
                    "type"=> "UPSELL",
                    "content"=> $product_page_content,
                    "locations"=>array(
                        'HOME_PAGE','PRODUCT_PAGE','CART_PAGE'
                    )
                ),
                array(
                    "type"=> "ELIGIBLE",
                    "content"=> $cart_page_content,
                    "locations"=>array(
                        "CART_PAGE"
                    )
                ),
                array(
                    "type"=> "APPLIED",
                    "content"=> $congratulation_content,
                    "locations"=>array(
                        "CART_PAGE"
                    )
                )
            ),
            "stop"=> false,
            "status"=> "ENABLED",
            'start_date'=>$start_date.$start_time_ajusted,
            'end_date'=>$end_date.$end_time_ajusted,
        );

        $post_data = json_encode($post_data);
        $url = $API_PATH."/v3/promotions";
        $response = curlPostRequest($url, $headers, $post_data);
        if($response["data"]){
            return array("status"=> "success", "message"=> "Promotion created successfuly!");
        }
        else{
            return array("status"=> "error", "message"=> $promo_name);
        }

    }
    
    function product6($data){  // Percentage Off

        global $headers;
        global $store_hash;
        global $API_PATH;

        global $start_time_ajusted;
        global $end_time_ajusted;
        global $channel_id;
        

        $promo_name = $data[0];
        $promo_prod_id = $data[1];
        $percentage_amount = $data[2];
        $currency_code = $data[3];
        $product_page_content = $data[4];
        $cart_page_content = $data[5];
        $congratulation_content = $data[6];
        $start_date = date("Y-m-d", strtotime($data[7]));
        $end_date = date("Y-m-d", strtotime($data[8]));

        $post_data = array(
            "name"=> $promo_name,
            "channels"=>array(
                array(
                    "id"=> $channel_id
                )
            ),
            "redemption_type"=> "AUTOMATIC",
            "currency_code"=> $currency_code,
            "rules"=> array(
                array(
                    "apply_once"=> false,
                    "condition"=> array(
                        "cart"=> array(
                            "items"=> array(
                                "products"=> array(
                                    $promo_prod_id
                                )
                            )
                        )
                    ),
                    "action"=> array(
                        "cart_items"=> array(
                            "discount"=> array(
                                "percentage_amount"=> $percentage_amount
                            ),
                            "items"=> array(
                                "products"=> array(
                                    $promo_prod_id
                                )
                            ),
                            "quantity"=> 1,
                            "include_items_considered_by_condition"=> true
                        )
                    )
                )
            ),
            "notifications"=>array(
                array(
                    "type"=> "UPSELL",
                    "content"=> $product_page_content,
                    "locations"=>array(
                        'HOME_PAGE','PRODUCT_PAGE','CART_PAGE'
                    )
                ),
                array(
                    "type"=> "ELIGIBLE",
                    "content"=> $cart_page_content,
                    "locations"=>array(
                        "CART_PAGE"
                    )
                ),
                array(
                    "type"=> "APPLIED",
                    "content"=> $congratulation_content,
                    "locations"=>array(
                        "CART_PAGE"
                    )
                )
            ),
            "stop"=> false,
            "status"=> "ENABLED",
            'start_date'=>$start_date.$start_time_ajusted,
            'end_date'=>$end_date.$end_time_ajusted,
        );
        $post_data = json_encode($post_data);
        $url = $API_PATH."/v3/promotions";
        $response = curlPostRequest($url, $headers, $post_data);
        if($response["data"]){
            return array("status"=> "success", "message"=> "Promotion created successfuly!");
        }
        else{
            return array("status"=> "error", "message"=> $promo_name);
        }

    }

?>