# Contributing to the Hello World App

Thanks for showing interest in contributing!

The following is a set of guidelines for contributing to the BigCommerce Hello World app. These are just guidelines, not rules. Use your best judgment, and feel free to propose changes to this document in a pull request.

#### Table of Contents

[API Documentation](https://developer.bigcommerce.com/api)

[How Can I Contribute?](#how-can-i-contribute)
  * [Your First Code Contribution](#your-first-code-contribution)
  * [Pull Requests](#pull-requests)

[Styleguides](#styleguides)
  * [Git Commit Messages](#git-commit-messages)
  * [PHP Styleguide](#php-styleguide)

### Your First Code Contribution

Unsure where to begin contributing to the API client? Check our [forums](https://forum.bigcommerce.com/s/group/0F913000000HLjECAW), our [stackoverflow](https://stackoverflow.com/questions/tagged/bigcommerce) tag, and the reported [issues](https://github.com/bigcommerce/hello-world-app-php-silex/issues).

### Pull Requests

* Fill in [the required template](https://github.com/bigcommerce/hello-world-app-php-silex/pull/new/master)
* Include screenshots and animated GIFs in your pull request whenever possible.
* End files with a newline.

## Styleguides

### Git Commit Messages

* Use the present tense ("Add feature" not "Added feature")
* Use the imperative mood ("Move cursor to..." not "Moves cursor to...")
* Limit the first line to 72 characters or less
* Reference pull requests and external links liberally


### PHP Styleguide

All PHP must adhere to [PSR2 PHP Styleguide](https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-2-coding-style-guide.md).
