<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require 'vendor/autoload.php';

use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;

$cert_file = 'p75.a65.mytemp.website.crt';
$key_file = 'private_key_for_csr.key';

$client = new Client([
    'base_uri' => 'https://api.compassplus.com:11611',
    'timeout'  => 10.0,
]);

try {
    $response = $client->post('/Exec', [
        'headers' => [
            'Content-Type' => 'text/xml',
        ],
        'body' => '<?xml version="1.0" encoding="UTF-8"?>
                    <TKKPG>
                        <Request>
                            <Operation>CreateOrder</Operation>
                            <Language>EN</Language>
                            <Order>
                                <OrderType>Purchase</OrderType>
                                <Merchant>NABIL106698</Merchant>
                                <Amount>100</Amount>
                                <Currency>524</Currency>
                                <Description>123XXXX</Description>
                                <ApproveURL>abc.com</ApproveURL>
                                <CancelURL>abc1.com</CancelURL>
                                <DeclineURL>abc2.com</DeclineURL>
                                <Fee>0</Fee>
                            </Order>
                        </Request>
                    </TKKPG>',
        'cert' => $cert_file,
        'ssl_key' => $key_file,
        'verify' => false, // Disable SSL peer verification if necessary (not recommended for production)
    ]);

    echo $response->getBody();
} catch (RequestException $e) {
    echo "Error: " . $e->getMessage();
}

?>