<?php 
	error_reporting(E_ALL);
	ini_set('display_errors', 1);
	ini_set('display_startup_errors', 1);
	
	include 'inc/database.php';
	include 'requestFunctions.php';

	global $conn;
	require_once __DIR__ . '/vendor/autoload.php';

	use Bigcommerce\Api\Client as Bigcommerce;

    $file_data = array();


	$data = array(
	  "client_id" 		=> CLIENT_ID,
	  "client_secret" 	=> CLIENT_SECRET,
	  "redirect_uri" 	=> REDIRECT_URL,
	  "grant_type" 		=> GRANT_TYPE,
	  "code" 			=> $_GET["code"],
	  "scope" 			=> $_GET["scope"],
	  "context" 		=> $_GET["context"],
	);

    $file_data["postfields"] = $data;
    
	$postfields = http_build_query($data);

	$ch = curl_init();                    
	$url = "https://login.bigcommerce.com/oauth2/token";
	curl_setopt($ch, CURLOPT_URL,$url);
	curl_setopt($ch, CURLOPT_POST, true);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $postfields);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	$output = curl_exec ($ch);
	curl_close ($ch);
	// print_r($output);
	$obj = json_decode($output);
    $file_data["res_obj"] = $obj;
    
	$access_token = $obj->access_token;

	Bigcommerce::configure(array(
		'client_id'  =>  CLIENT_ID,
		'auth_token' => $access_token,
		'store_hash' => str_replace("stores/","", $_GET["context"])
	));

	Bigcommerce::verifyPeer(false);
	
	// $ping = Bigcommerce::getTime();

	$store = (array)Bigcommerce::getConnection()->get(Bigcommerce::$api_path . '/store');	
	
	//print_r($store);
	
	
	$API_PATH = 'https://api.bigcommerce.com/stores/'.$store['id'];
	$channel_url = $API_PATH."/v3/channels";
	
	$headers = array(
		"accept: application/json",
		"content-type: application/json",
		"x-auth-client: ".CLIENT_ID,
		"x-auth-token: ".$access_token
	);
	
	$file_data["header"] = $headers;
	
	$channel_data = curlGetRequest($channel_url, $headers);
	$file_data["channel_data"] = $channel_data;

	if($channel_data["data"]){
	    $file_data["in_channel_data_if"] = "yes";
		foreach ($channel_data["data"] as $key => $channel) {
			$file_data["in_channel_data_each"][$key] = "yes";
			
			$channel_id = $channel["id"];
			$channel_name = $channel["name"];
			if($channel["platform"] == "bigcommerce" && $channel["type"] == "storefront"){
			    
				$file_data["in_channel_data_each_if"][$key] = "yes";
				
				$url = $API_PATH."/v3/sites?channel_id:in=$channel_id";
				$result_site = curlGetRequest($url, $headers);
				
				$file_data["result_site"][$key] = $result_site;
				
				if($result_site["data"] && $result_site["data"][0]){
					$store_url = $result_site["data"][0]["url"];
				}  
				
				$store_data						= array();
				$store_data['access_token']		= $access_token;
				$store_data['store_id']			= $store['id'];
				$store_data['store_url']		= addslashes($store_url);
				$store_data['store_name']		= addslashes($channel_name);
				$store_data['channel_id']		= addslashes($channel_id);
				$store_data['admin_first_name']	= addslashes($store['first_name']);
				$store_data['admin_last_name']	= addslashes($store['last_name']);
				$store_data['country']			= $store['country'];
				$store_data['country_code']		= $store['country_code'];
				$store_data['phone']			= $store['phone'];
				$store_data['admin_email']		= $store['admin_email'];
				$store_data['currency']			= $store['currency'];
				$store_data['currency_symbol']	= $store['currency_symbol'];
				$store_data['stencil_enabled']	= $store['features']->stencil_enabled ? 1 : 0;
				$store_data['uninstall']		= 0;
				
				$check = $db->getSingleColumn("stores", "attempt", array( "store_id" => $store['id'], "channel_id" => $channel_id) );
				if(!$check) {
					$store_data['created_at'] = date("Y-m-d H:i:s");
					$store_settings = $db->insert( "stores", $store_data );
				} else {
					$store_data['updated_at'] = date("Y-m-d H:i:s");
					$store_data['attempt']		= $check+1;
					$store_settings = $db->update( "stores", $store_data, array("store_id" => $store['id'], "channel_id" => $channel_id));	
				}
				
				$file_data["query_data"][$key] = $store_data;
			}
			else{
			    $file_data["in_channel_data_each_else"][$key] = "yes";
			}
		}
	}
	else{
	    $file_data["in_channel_data_else"] = "yes";
	}
	
	$filename		= "logs/store_".time().".txt";
	file_put_contents($filename, print_r($file_data, true));
	chmod($filename, 0777);
	
	$URL=BASE_PATH."load.php?store_hash=".str_replace("stores/","", $_GET["context"])."";
	echo ("<script>location.href='$URL'</script>");
?>
