<?php 
	// ini_set("error_reporting", E_ALL);
	// ini_set("display_errors", true);

	include_once 'inc/functions.php';
	include_once 'inc/database.php';
	
	require_once __DIR__ . '/vendor/autoload.php';
	use Bigcommerce\Api\Client as Bigcommerce;
    
	$config = array();


	if( isset($_GET['signed_payload']) || (isset($_GET['store_hash']) && !empty($_GET['store_hash'])) ){
		$data = decodeSignedRequest($_GET['signed_payload']);
		$hash = isset($data['store_hash']) ? $data['store_hash'] : $_GET['store_hash'];

		$access_payload	= $_GET['signed_payload'];
		$access_token = $db->getSingleColumn( "stores", "access_token", array( "store_id" => $hash ));
		if( $access_token == "")
			die("store access token not found.");
		$config = array(
			'client_id'  => CLIENT_ID,
			'auth_token' => $access_token,
			'store_hash' => $hash
		);
		Bigcommerce::configure($config);
		Bigcommerce::verifyPeer(false);	
		// end of setup

		$API_PATH = 'https://api.bigcommerce.com/stores/'.$hash;

		$headers = array(
			"accept: application/json",
			"content-type: application/json",
			"x-auth-client: ".CLIENT_ID,
			"x-auth-token: ".$access_token
		);
		$created_date = $db->select("stores", "*", array( "store_id" => $hash));

	}

?>
<!doctype html>
<html>
    <head>
	
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        
        <meta name="description" content="">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Bigcommerce Automatic Promotions App</title>
        
		<link type="text/css" rel="stylesheet" href="<?php  echo BASE_PATH ?>assets/css/style.css">
		<link type="text/css" rel="stylesheet" href="<?php  echo BASE_PATH ?>assets/css/custom.css">

        <!-- bootstrap -->
        <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" integrity="sha384-JcKb8q3iqJ61gNV9KGb8thSsNjpSL0n8PARn9HuZOnIxN0hoP+VmmDGMN5t9UJ0Z" crossorigin="anonymous">
        <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js" integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj" crossorigin="anonymous"></script>
        <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js" integrity="sha384-B4gt1jrGC7Jh4AgTPSdUtOBvfO8shuf57BaghqFfPlYxofvL8/KUEfYiJOMMV+rV" crossorigin="anonymous"></script>
        <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.bundle.min.js" integrity="sha384-LtrjvnR4Twt/qOuYxE721u19sVFLVSA4hf/rRt6PrZTmiPltdZcI7q7PXQBYTKyf" crossorigin="anonymous"></script>
        <!-- bootstrap -->

		 <!-- Add icon library -->
		<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
        <script  src="https://code.jquery.com/jquery-3.3.1.js"></script>
        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.19/js/jquery.dataTables.min.js" type="text/javascript" charset="utf-8" ></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.19/js/dataTables.bootstrap.min.js" type="text/javascript" charset="utf-8" ></script>  
		<style>
            .wep-thankyou-conaiter{
                text-align: center !important;
            }
            .cstm-clr{
                color: #6AB865 !important;
            }
            .cstm-link{
                text-decoration: none !important;
            }
			.wep-thankyou-conaiter h1{
				font-size:55px !important;
			}
			.fa-check{
				font-size: 40px !important;
			}
			.container{
				width:80% !important
			}
			.cstm-back-btn{
				background: none;
				border: none;
				cursor: pointer;
				box-shadow: none;
				outline: none;
			}
			.cstm-back-btn:focus{
				outline: none;
			}
		</style>

    </head>
    <body>
        <div class="app_conatiner">
			<div id="main_content">
				<div class="sub_conatiner clearfix">
					<div class="mt-5">
                        <div class="container" >
                            <div class="wep-thankyou-conaiter" >
                                <h1 class="cstm-clr">THANK YOU!</h1>
                                <i class="fa fa-check cstm-clr mb-5"></i>
                            </div>
                            <div>
                                <p>Dear Jone Doe</p>
                                <p>Your payment for Bulk Promotions by WebEcommercePros is successful and your paid subscription is activated.</p>
                                <p>Thank you for choosing us.</p>
                                <button type="button" class="cstm-clr cstm-link cstm-back-btn" >Go to app dashboard.</button>
                            </div>
                        </div>
						<div class="logo-img" >
							<a href="https://www.webecommercepros.com/">
								<img src="<?php BASE_PATH ?>assets/images/logo.png" />
							</a>
						</div>
						<script>
							$(".cstm-back-btn").on('click', function(){
								window.location.replace('load.php?store_hash=<?php echo $hash; ?>');
							})
						</script>
					</div>
				</div>				
			</div>
		</div>				
	</body>				
</html>