<?php

    $start_time_ajusted = "T00:00:00".$timezone_val;
    $end_time_ajusted = "T23:59:59".$timezone_val;

    function category1($data){  // Get a $ or % Discount to Each Item in One or More Categories

        global $headers;
        global $store_hash;
        global $API_PATH;
        global $start_time_ajusted;
        global $end_time_ajusted;
        global $channel_id;

        $promo_name = $data[0];
        $promo_category_id = $data[1];
        $percentage_amount = $data[2];
        $currency_code = $data[3];
        $product_page_content = $data[4];
        $cart_page_content = $data[5];
        $congratulation_content = $data[6];
        $start_date = date("Y-m-d", strtotime($data[7]));
        $end_date = date("Y-m-d", strtotime($data[8]));

        $post_data = array(
            "name"=> $promo_name,
            "channels"=>array(
                array(
                    "id"=> $channel_id
                )
            ),
            "redemption_type"=> "AUTOMATIC",
            "currency_code"=> $currency_code,
            "rules"=>array(
                array(
                    "action"=> array(
                        "cart_items"=> array(
                            "discount"=> array(
                                "percentage_amount"=> $percentage_amount
                            ),
                            "strategy"=> "LEAST_EXPENSIVE",
                            "as_total"=> false,
                            "include_items_considered_by_condition"=> false,
                            "items"=> array(
                                "categories"=> array(
                                    $promo_category_id
                                )
                            )
                        )
                    ),
                    "stop"=> false,
                    "apply_once"=> true,
                )
            ),
            "notifications"=>array(
                array(
                    "type"=> "UPSELL",
                    "content"=> $product_page_content,
                    "locations"=>array(
                        'HOME_PAGE','PRODUCT_PAGE','CART_PAGE'
                    )
                ),
                array(
                    "type"=> "ELIGIBLE",
                    "content"=> $cart_page_content,
                    "locations"=>array(
                        "CART_PAGE"
                    )
                ),
                array(
                    "type"=> "APPLIED",
                    "content"=> $congratulation_content,
                    "locations"=>array(
                        "CART_PAGE"
                    )
                )
            ),
            "stop"=> false,
            "status"=> "ENABLED",
            'start_date'=>$start_date.$start_time_ajusted,
            'end_date'=>$end_date.$end_time_ajusted,
        );

        $post_data = json_encode($post_data);
        $url = $API_PATH."/v3/promotions";
        $response = curlPostRequest($url, $headers, $post_data);
        if($response["data"]){
            return array("status"=> "success", "message"=> "Promotion created successfuly!");
        }
        else{
            return array("status"=> "error", "message"=> $promo_name);
        }

    }
    
    function category2($data){  // Get a % discount to each Item in one or more categories, exclude items on sale

        global $headers;
        global $store_hash;
        global $API_PATH;
        global $start_time_ajusted;
        global $end_time_ajusted;
        global $channel_id;

        $promo_name = $data[0];
        $promo_category_id = $data[1];
        $percentage_amount = $data[2];
        $currency_code = $data[3];
        $product_page_content = $data[4];
        $cart_page_content = $data[5];
        $congratulation_content = $data[6];
        $start_date = date("Y-m-d", strtotime($data[7]));
        $end_date = date("Y-m-d", strtotime($data[8]));

        $post_data = array(
            "name"=> $promo_name,
            "redemption_type"=> "AUTOMATIC",
            "currency_code"=> $currency_code,
            "rules"=>array(
                array(
                    "action"=> array(
                        "cart_items"=> array(
                            "discount"=> array(
                                "percentage_amount"=> $percentage_amount
                            ),
                            "strategy"=> "LEAST_EXPENSIVE",
                            "as_total"=> false,
                            "exclude_items_on_sale"=> true,
                            "include_items_considered_by_condition"=> false,
                            "items"=> array(
                                "categories"=> array(
                                    $promo_category_id
                                )
                            )
                        )
                    ),
                    "stop"=> false,
                    "apply_once"=> true,
                )
            ),
            "notifications"=>array(
                array(
                    "type"=> "UPSELL",
                    "content"=> $product_page_content,
                    "locations"=>array(
                        'HOME_PAGE','PRODUCT_PAGE','CART_PAGE'
                    )
                ),
                array(
                    "type"=> "ELIGIBLE",
                    "content"=> $cart_page_content,
                    "locations"=>array(
                        "CART_PAGE"
                    )
                ),
                array(
                    "type"=> "APPLIED",
                    "content"=> $congratulation_content,
                    "locations"=>array(
                        "CART_PAGE"
                    )
                )
            ),
            "stop"=> false,
            "status"=> "ENABLED",
            'start_date'=>$start_date.$start_time_ajusted,
            'end_date'=>$end_date.$end_time_ajusted,
        );

        $post_data = json_encode($post_data);
        $url = $API_PATH."/v3/promotions";
        $response = curlPostRequest($url, $headers, $post_data);
        if($response["data"]){
            return array("status"=> "success", "message"=> "Promotion created successfuly!");
        }
        else{
            return array("status"=> "error", "message"=> $promo_name);
        }

    }
    
    function category3($data){  // Buy X Units in (Category A), Get Y Additional Units in the Same Category Free (Must be of Equal or Lesser Value)

        global $headers;
        global $store_hash;
        global $API_PATH;
        global $start_time_ajusted;
        global $end_time_ajusted;
        global $channel_id;

        $promo_name = $data[0];
        $target_category_id = $data[1];
        $target_quantity = $data[2];
        $promo_quantity = $data[3];
        $currency_code = $data[4];
        $product_page_content = $data[5];
        $cart_page_content = $data[6];
        $congratulation_content = $data[7];
        $start_date = date("Y-m-d", strtotime($data[8]));
        $end_date = date("Y-m-d", strtotime($data[9]));

        $post_data = array(
            "name"=> $promo_name,
            "redemption_type"=> "AUTOMATIC",
            "currency_code"=> $currency_code,
            "rules"=>array(
                array(
                    "action"=> array(
                        "cart_items"=> array(
                            "discount"=> array(
                                "percentage_amount"=> "100"
                            ),
                            "strategy"=> "LEAST_EXPENSIVE",
                            "as_total"=> false,
                            "include_items_considered_by_condition"=> false,
                            "items"=> array(
                                "categories"=> array(
                                    $target_category_id
                                )
                            ),
                            "quantity"=> $promo_quantity
                        )
                    ),
                    "stop"=> false,
                    "apply_once"=> true,
                    "condition"=> array(
                        "cart"=> array(
                          "items"=> array(
                            "categories"=> array(
                              $target_category_id,
                            )
                          ),
                          "minimum_quantity"=> $target_quantity,
                        )
                    )
                )
            ),
            "notifications"=>array(
                array(
                    "type"=> "UPSELL",
                    "content"=> $product_page_content,
                    "locations"=>array(
                        'HOME_PAGE','PRODUCT_PAGE','CART_PAGE'
                    )
                ),
                array(
                    "type"=> "ELIGIBLE",
                    "content"=> $cart_page_content,
                    "locations"=>array(
                        "CART_PAGE"
                    )
                ),
                array(
                    "type"=> "APPLIED",
                    "content"=> $congratulation_content,
                    "locations"=>array(
                        "CART_PAGE"
                    )
                )
            ),
            "stop"=> false,
            "status"=> "ENABLED",
            'start_date'=>$start_date.$start_time_ajusted,
            'end_date'=>$end_date.$end_time_ajusted,
        );

        $post_data = json_encode($post_data);
        $url = $API_PATH."/v3/promotions";
        $response = curlPostRequest($url, $headers, $post_data);
        if($response["data"]){
            return array("status"=> "success", "message"=> "Promotion created successfuly!");
        }
        else{
            return array("status"=> "error", "message"=> $promo_name);
        }

    }
    

?>