<?php


    function curlGetRequest($url, $headers){
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => $headers,
        ));    
        $response = curl_exec($curl);
        $err = curl_error($curl);    
        curl_close($curl);

        if ($err) {
            return json_decode($err, true);
        } else {
            return json_decode($response, true);
        }
    }

    function curlPostRequest($url, $headers, $postFields){
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_POSTFIELDS=> $postFields
        ));    
        $response = curl_exec($curl);
        $err = curl_error($curl);    
        curl_close($curl);

        if ($err) {
            return json_decode($err, true);
        } else {
            return json_decode($response, true);
        }
    }

    function curlDeleteRequest($url, $headers){
        $ch = curl_init();
        curl_setopt_array($ch, array(
            CURLOPT_URL=> $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_CUSTOMREQUEST => "DELETE",
            CURLOPT_HTTPHEADER => $headers,
        ));
        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);
        if($err){
            return json_decode($err, true);
        }
        else {
            return json_decode($response, true);
        }
    }
    
    function curlPutRequest($url, $headers, $postFields){
        $ch = curl_init();
        curl_setopt_array($ch, array(
            CURLOPT_URL=> $url,
            CURLOPT_ENCODING => "",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_CUSTOMREQUEST => 'PUT',
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_POSTFIELDS => $postFields
        ));
        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);
        if($err){
            return json_decode($err, true);
        }
        else {
            return json_decode($response, true);
        }
    }
?>