<?php

    $start_time_ajusted = "T00:00:00".$timezone_val;
    $end_time_ajusted = "T23:59:59".$timezone_val;

    function order1($data){  // Spend X$ Get X$ Off Order

        global $headers;
        global $store_hash;
        global $API_PATH;
        global $start_time_ajusted;
        global $end_time_ajusted;
        global $channel_id;

        $promo_name = $data[0];
        $amount_to_spend = $data[1];
        $discount_amount = $data[2];
        $currency_code = $data[3];
        $product_page_content = $data[4];
        $cart_page_content = $data[5];
        $congratulation_content = $data[6];
        $start_date = date("Y-m-d", strtotime($data[7]));
        $end_date = date("Y-m-d", strtotime($data[8]));

        $post_data = array(
            "name"=> $promo_name,
            "channels"=>array(
                array(
                    "id"=> $channel_id
                )
            ),
            "redemption_type"=> "AUTOMATIC",
            "currency_code"=> $currency_code,
            "rules"=>array(
                array(
                    "action"=> array(
                        "cart_value"=> array(
                            "discount"=> array(
                                "fixed_amount"=> $discount_amount
                            ),
                        )
                    ),
                    "stop"=> true,
                    "apply_once"=> true,
                    "condition"=> array(
                        "cart"=> array(
                          "minimum_spend"=> $amount_to_spend
                        )
                    )
                )
            ),
            "notifications"=>array(
                array(
                    "type"=> "UPSELL",
                    "content"=> $product_page_content,
                    "locations"=>array(
                        'HOME_PAGE','PRODUCT_PAGE','CART_PAGE'
                    )
                ),
                array(
                    "type"=> "ELIGIBLE",
                    "content"=> $cart_page_content,
                    "locations"=>array(
                        "CART_PAGE"
                    )
                ),
                array(
                    "type"=> "APPLIED",
                    "content"=> $congratulation_content,
                    "locations"=>array(
                        "CART_PAGE"
                    )
                )
            ),
            "stop"=> false,
            "status"=> "ENABLED",
            'start_date'=>$start_date.$end_time_ajusted,
            'end_date'=>$end_date.$end_time_ajusted,
        );

        $post_data = json_encode($post_data);
        $url = $API_PATH."/v3/promotions";
        $response = curlPostRequest($url, $headers, $post_data);
        // echo "<pre>";
        // print_r($data);
        // print_r($post_data);
        // print_r($response);
        // echo "</pre>";
        // exit();
        if($response["data"]){
            return array("status"=> "success", "message"=> "Promotion created successfuly!");
        }
        else{
            return array("status"=> "error", "message"=> $promo_name);
        }

    }  

    function order2($data){  // Order at Least $X Get X Item Free

        global $headers;
        global $store_hash;
        global $API_PATH;
        global $start_time_ajusted;
        global $end_time_ajusted;
        global $channel_id;

        $promo_name = $data[0];
        $amount_to_spend = $data[1];
        $promo_product_id = $data[2];
        $currency_code = $data[3];
        $product_page_content = $data[4];
        $cart_page_content = $data[5];
        $congratulation_content = $data[6];
        $start_date = date("Y-m-d", strtotime($data[7]));
        $end_date = date("Y-m-d", strtotime($data[8]));

        $post_data = array(
            "name"=> $promo_name,
            "channels"=>array(
                array(
                    "id"=> $channel_id
                )
            ),
            "redemption_type"=> "AUTOMATIC",
            "rules"=>array(
                array(
                    "action"=> array(
                        "gift_item"=> array(
                            "product_id"=> $promo_product_id,
                            "quantity"=> 1
                        )
                    ),
                    "stop"=> false,
                    "apply_once"=> true,
                    "currency_code"=> $currency_code,
                    "condition"=> array(
                        "cart"=> array(
                          "minimum_spend"=> $amount_to_spend
                        )
                    )
                )
            ),
            "notifications"=>array(
                array(
                    "type"=> "UPSELL",
                    "content"=> $product_page_content,
                    "locations"=>array(
                        'HOME_PAGE','PRODUCT_PAGE','CART_PAGE'
                    )
                ),
                array(
                    "type"=> "ELIGIBLE",
                    "content"=> $cart_page_content,
                    "locations"=>array(
                        "CART_PAGE"
                    )
                ),
                array(
                    "type"=> "APPLIED",
                    "content"=> $congratulation_content,
                    "locations"=>array(
                        "CART_PAGE"
                    )
                )
            ),
            "stop"=> false,
            "status"=> "ENABLED",
            'start_date'=>$start_date.$end_time_ajusted,
            'end_date'=>$end_date.$end_time_ajusted,
        );

        $post_data = json_encode($post_data);
        $url = $API_PATH."/v3/promotions";
        $response = curlPostRequest($url, $headers, $post_data);
        if($response["data"]){
            return array("status"=> "success", "message"=> "Promotion created successfuly!");
        }
        else{
            return array("status"=> "error", "message"=> $promo_name);
        }

    }  

?>